/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.client.event.tooltip;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import gloridifice.watersource.client.hud.WaterLevelHUD;
import gloridifice.watersource.common.recipe.ThirstItemRecipe;
import gloridifice.watersource.common.recipe.WaterLevelItemRecipe;
import gloridifice.watersource.registry.BlockRegistry;
import gloridifice.watersource.registry.ConfigRegistry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="watersource")
public class WaterLevelTooltip {
    private static double tick = 0.0;
    private static int x;

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        x = 1;
        if (((Boolean)ConfigRegistry.OPEN_FOOD_WATER_LEVEL.get()).booleanValue()) {
            Minecraft mc = Minecraft.func_71410_x();
            WaterLevelItemRecipe recipe = WaterLevelItemRecipe.getRecipeFromItem((World)mc.field_71441_e, event.getItemStack());
            if (recipe != null) {
                StringBuilder stringBuilder = new StringBuilder(" ");
                for (int i = 0; i < recipe.getWaterLevel() / 2; ++i) {
                    stringBuilder.append("  ");
                }
                if (ModList.get().isLoaded("quark")) {
                    x += WaterLevelTooltip.getQuarkLineCount(event.getItemStack());
                }
                event.getToolTip().add(x, new StringTextComponent(stringBuilder.toString()));
            }
        }
        if (event.getItemStack().func_77973_b() == BlockRegistry.ITEM_WATER_DISPENSER) {
            event.getToolTip().add(new TranslationTextComponent("info.watersource.waterdipenser").func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GRAY))));
        }
    }

    @SubscribeEvent
    public static void onRenderTooltipEvent(RenderTooltipEvent.PostText event) {
        tick += 1.0;
        tick %= 2000.0;
        if (((Boolean)ConfigRegistry.OPEN_FOOD_WATER_LEVEL.get()).booleanValue()) {
            Minecraft mc = Minecraft.func_71410_x();
            WaterLevelItemRecipe wRecipe = WaterLevelItemRecipe.getRecipeFromItem((World)mc.field_71441_e, event.getStack());
            if (wRecipe != null) {
                int n;
                int i;
                int texU;
                event.getLines();
                RenderSystem.pushMatrix();
                RenderSystem.enableBlend();
                ThirstItemRecipe tRecipe = ThirstItemRecipe.getRecipeFromItem((World)mc.field_71441_e, event.getStack());
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                int a = 0;
                for (int i2 = 0; i2 < event.getLines().size(); ++i2) {
                    String s = ((ITextProperties)event.getLines().get(i2)).getString();
                    if (!(s = TextFormatting.func_110646_a((String)s)).trim().isEmpty()) continue;
                    a = i2;
                    break;
                }
                if (ModList.get().isLoaded("quark")) {
                    a += WaterLevelTooltip.getQuarkLineCount(event.getStack());
                }
                int OffsetY = WaterLevelTooltip.getQuarkLineCount(event.getStack()) >= 1 ? event.getY() + a * 9 + 3 : event.getY() + a * 9 + 2;
                int OffsetX = event.getX() - 1;
                int texU1 = texU = 0;
                int texU2 = texU;
                if (tRecipe != null) {
                    texU1 = texU + 18;
                    texU2 = texU + 9;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(WaterLevelHUD.OVERLAY_BAR);
                if (wRecipe.getWaterLevel() % 2 == 0) {
                    for (i = 0; i < wRecipe.getWaterLevel() / 2; ++i) {
                        AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + i * 9), (int)OffsetY, (float)(36 + texU2), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
                        AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + i * 9), (int)OffsetY, (float)texU1, (float)0.0f, (int)9, (int)9, (int)256, (int)256);
                    }
                } else {
                    AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)OffsetX, (int)OffsetY, (float)(36 + texU2), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
                    AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)OffsetX, (int)OffsetY, (float)(9 + texU1), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
                    for (n = 1; n < (wRecipe.getWaterLevel() + 1) / 2; ++n) {
                        AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + n * 9), (int)OffsetY, (float)(36 + texU2), (float)0.0f, (int)9, (int)9, (int)256, (int)256);
                        AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + n * 9), (int)OffsetY, (float)texU1, (float)0.0f, (int)9, (int)9, (int)256, (int)256);
                    }
                }
                if (tRecipe == null) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)Math.abs(Math.sin(tick / 40.0))));
                    if (wRecipe.getWaterLevel() % 2 == 0) {
                        for (i = 0; i < wRecipe.getWaterSaturationLevel() / 2; ++i) {
                            AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + i * 9), (int)(OffsetY + 1), (float)(9 + texU1), (float)9.0f, (int)9, (int)9, (int)256, (int)256);
                            AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + i * 9), (int)(OffsetY - 1), (float)texU1, (float)9.0f, (int)9, (int)9, (int)256, (int)256);
                        }
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + (wRecipe.getWaterSaturationLevel() / 2 - 1) * 9), (int)(OffsetY - 1), (float)texU1, (float)9.0f, (int)9, (int)9, (int)256, (int)256);
                        for (n = 0; n < (wRecipe.getWaterSaturationLevel() + 1) / 2 - 1; ++n) {
                            AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + n * 9), (int)(OffsetY - 1), (float)texU1, (float)9.0f, (int)9, (int)9, (int)256, (int)256);
                            AbstractGui.func_238463_a_((MatrixStack)event.getMatrixStack(), (int)(OffsetX + n * 9), (int)(OffsetY + 1), (float)(9 + texU1), (float)9.0f, (int)9, (int)9, (int)256, (int)256);
                        }
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                RenderSystem.disableBlend();
                RenderSystem.popMatrix();
            }
        }
    }

    public static int getQuarkLineCount(ItemStack itemStack) {
        int i = 0;
        List potions = PotionUtils.func_185189_a((ItemStack)itemStack);
        for (EffectInstance instance : potions) {
            if (instance.func_188419_a() == Effects.field_76421_d) {
                ++i;
            }
            if (instance.func_188419_a() == Effects.field_76424_c) {
                ++i;
            }
            if (instance.func_188419_a() == Effects.field_188425_z) {
                ++i;
            }
            if (instance.func_188419_a() == Effects.field_76437_t) {
                ++i;
            }
            if (instance.func_188419_a() == Effects.field_76420_g) {
                ++i;
            }
            if (instance.func_188419_a() != ForgeRegistries.POTIONS.getValue(new ResourceLocation("quark", "resilience"))) continue;
            ++i;
        }
        if (itemStack.func_222117_E()) {
            ++i;
        }
        return i;
    }
}

